C      *****************************************************************
C      * Function PickNext                                             *
C      * Returns the next item in the list between First and Last for  *
C      * elements that are marked as available.  The following error   *
C      * conditions are possible:                                      *
C      * (1) If all elements between first and last are unavailable an *
C      *     error message is output and the program quits.            *
C      * (2) First and Last could go beyond the array boundaries of the*
C      *     availability array.  It is up to the calling program to   *
C      *     make sure that this does not happen.                      *
C      *                                                               *
C      * Variables:                                                    *
C      * ASize     -Local - Parameter used to size Avail vector.       *
C      *                    Unitless.                                  *
C      * Avail     -Input - A vector, of size ASize, that indicates    *
C      *                    whether item is available (TRUE) or not    *
C      *                    (FALSE).  Unitless.                        *
C      * First     -Input - The index of the first item in the list.   *
C      *                    Unitless.                                  *
C      * GoAhead   -Output- Indicates whether any errors were found.   *
C      *                    (GoAhead=1, no errors found; GoAhead=0,    *
C      *                    errors found.)  Unitless.                  *
C      * Index     -Local - Array index.  Unitless.                    *
C      * Last      -Input - The index of the last item in the list.    *
C      *                    Unitless.                                  *
C      * LastIndex -In/Out- The index of the last picked element.      *
C      *                    Unitless.                                  *
C      * PickNext  -Fcn/Out-Integer value of index of next available   *
C      *                    item.  Unitless.                           *
C      *****************************************************************
       INTEGER FUNCTION PICKNEXT(FIRST, LAST, AVAIL, LASTINDEX, GOAHEAD)
							IMPLICIT NONE
       INTEGER ASIZE, FIRST, GOAHEAD, INDEX, LAST, LASTINDEX
       PARAMETER (ASIZE = 50)
       LOGICAL AVAIL(ASIZE)
 
C      *------------------------------------*
C      * Indicate that there are no errors. *
C      *------------------------------------*
       GOAHEAD = 1

C      *-------------------------------------------------------------*
C      * Check to see that at least one value between first and last *
C      * is available.                                               *
C      *-------------------------------------------------------------*
       DO 100 INDEX = FIRST, LAST
          IF (AVAIL(INDEX)) THEN 
             GOTO 8888
          ENDIF
  100  CONTINUE

C      *-------------------------------------------------------------*
C      * If code is here it means that there are no items available, *
C      * Send a flag to calling routine indicating that an error     *
C      * occurred.                                                   *
C      *-------------------------------------------------------------*
       GOAHEAD = 0
       GOTO 9999

C      *---------------------------------*
C      * At least one item is available. *
C      *---------------------------------*
 8888  CONTINUE

C      *-----------------------------------------------------------------*     
C      * Get the index of the next item and determine if it's available. *
C      * If it is, leave, if not get the next item and repeat.           *
C      *-----------------------------------------------------------------* 
 1000  CONTINUE
          IF (LASTINDEX.EQ.LAST) THEN
             LASTINDEX = FIRST
          ELSE
             LASTINDEX = LASTINDEX + 1
          ENDIF

       IF (.NOT.(AVAIL(LASTINDEX))) GOTO 1000

       PICKNEXT = LASTINDEX

C      *---------------*
C      * Escape hatch. *
C      *---------------*
 9999  CONTINUE

	      RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
